if ( typeof DOMParser == "undefined" ) {
	DOMParser = function () {} ;

	DOMParser.prototype.parseFromString = function ( str, contentType ) {
		if ( typeof ActiveXObject == "function" ) {
			var dom = new ActiveXObject( "MSXML.DomDocument" ) ;
			dom.loadXML( '<?xml version="1.0" encoding="utf-8" ?>\n' + str.replace( /^(<\?xml(.*?)\?>\s*)?<!DOCTYPE(.*?)>\s*/, '' ) ) ;
			return dom ;
		}
		
		if ( typeof XMLHttpRequest != "undefined") {
			var req = new XMLHttpRequest ;
			req.open(
				"GET",
				"data:" + ( contentType || "application/xml") + ";charset=utf-8," + encodeURIComponent( str ),
				false
			) ;
			
			if ( req.overrideMimeType ) {
				req.overrideMimeType( contentType ) ;
			}
			
			req.send( null ) ;
			
			return req.responseXML ;
		}
	}
}


var XML_ELEMENT_NODE		= 1 ;
var XML_TEXT_NODE			= 3 ;
var XML_CDATA_SECTION_NODE	= 4 ;
var XML_COMMENT_NODE		= 8 ;


var JTE = function() {
	this.templateAttribute = 'jte' ;
    this.encoding = 'UTF-8' ;
    this.docType = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'
    this.xhtml = true
    
    this.emptyTag = [
      'meta',
      'base',
      'link',
      'basefont',
      'spacer',
      'br',
      'wbr',
      'hr',
      'img',
      'area',
      'param',
      'bgsound',
      'input'
    ] ;
    
    this.blankAttribute = [
      'checked',
      'compact',
      'declare',
      'defer',
      'disabled',
      'ismap',
      'multiple',
      'nohref',
      'noresize',
      'noshade',
      'nowrap',
      'selected',
      'target'
    ] ;
    
    this.urlAttribute = [
      'href',
      'src',
      'background',
      'cite',
      'action'
    ] ;
	
	this.data = {
		'condition'		: {},
		'value'			: {},
		'record'		: {},
		'function'		: {}
	} ;
	
	this.xhtml = true ;
	
	this.isMSIE = /*@cc_on!@*/false ;
	
	//==================================================================
	// set
	
	this.set = function( data ) {
		if ( data[ 'condition' ] ) {
			this.set_conditions( data[ 'condition' ] ) ;
		}
		
		if ( data[ 'value' ] ) {
			this.set_values( data[ 'value' ] ) ;
		}
		
		if ( data[ 'record' ] ) {
			this.set_records( data[ 'record' ] ) ;
		}
		
		if ( data[ 'function' ] ) {
			this.set_functions( data[ 'function' ] ) ;
		}
	}
	
	this.set_conditions = function( values ) {
		for ( var name in values ) {
			this.set_condition( name, values[ name ] ) ;
		}
	}
	
	this.set_condition = function( name, value ) {
		this.data[ 'condition' ][ name ] = value ;
		
	}
	
	this.set_values = function( values ) {
		for ( var name in values ) {
			this.set_value( name, values[ name ] ) ;
		}
	}
	
	this.set_value = function( name, value ) {
		this.data[ 'value' ][ name ] = value ;
		
	}
	
	this.set_records = function( values ) {
		for ( var name in values ) {
			this.set_record( name, values[ name ] ) ;
		}
	}
	
	this.set_record = function( name, value ) {
		this.data[ 'record' ][ name ] = value ;
		
	}
	
	this.set_functions = function( values ) {
		for ( var name in values ) {
			this.set_function( name, values[ name ] ) ;
		}
	}
	
	this.set_function = function( name, value ) {
		this.data[ 'function' ][ name ] = value ;
		
	}
	
	
	//==================================================================
	// load
	
	this.load = function( path ) {
		var html = this.get_contents( path ) ;
		
		this.dom = new DOMParser().parseFromString( html, 'application/xhtml+xml' ) ;
	} ;
	
	
	this._parse = function( element, html ) {
		var dom = new DOMParser().parseFromString( '<dom>' + html + '</dom>', 'application/xhtml+xml' ) ;
		
		for ( var n = 0 ; dom.documentElement.childNodes.length ; n++ ) {
			element.appendChild( dom.documentElement.childNodes.item( n ).cloneNode( true ) ) ;
		}
	} ;
	
	
	//==================================================================
	// replace
	
	this.replace = function() {
		this.tagEnd = ( this.xhtml ) ? ' /' : '' ;
		
		this.replace_pending = [] ;		// element, command, html
		
		this.data[ 'root' ] = this.data ;
		
		this.data[ 'parent' ] = {
			'condition'		: {},
			'value'			: {},
			'record'		: {},
			'function'		: {}
		} ;
		
		var records = {} ;				// { name }{ elements, data, records }
		
		this.replace_element( this.dom.documentElement, this.data, records, false ) ;
		
		for ( var name in records ) {
			this.replace_record( records[ name ] ) ;
		}
		
		// outer, inner
		
		for ( var p = 0 ; p < this.replace_pending.length ; p++ ) {
			var html = this.replace_pending[ p ][ 'text' ] ;
			
			if ( typeof html == "undefined" ) {
				continue ;
			}
			
			var dom = new DOMParser().parseFromString( '<dom>' + html + '</dom>', 'application/xhtml+xml' ) ;

			var element = this.replace_pending[ p ][ 'element' ] ;
			
			switch ( this.replace_pending[ p ][ 'command' ] ) {
			case 'outer' :
				for ( var n = 0 ; n < dom.documentElement.childNodes.length ; n++ ) {
					element.parentNode.insertBefore( dom.documentElement.childNodes.item( n ).cloneNode( true ), element ) ;
				}
				
				element.parentNode.removeChild( element ) ;
				
				break ;
			
			case 'inner' :
				while ( element.childNodes.length > 0 ) {
					element.removeChild( element.firstChild ) ;
				}
				
				for ( var n = 0 ; n < dom.documentElement.childNodes.length ; n++ ) {
					element.appendChild( dom.documentElement.childNodes.item( n ).cloneNode( true ) ) ;
				}
				
				break ;
			}

			delete dom ;
		}
	} ;
	
	
	// 0. (not jte attribute) (child) (exit)
	// 1. (not record) fake (exit)
	// 2. (not record) record (recall) (exit)
	// 3. (not record) if/else (exit)
	// 4. (not record) parse_outer (recall) (exit)
	// 5. (not record) outer (exit)
	// 6. attribute
	// 7. function
	// 8. text, textarea (exit)
	// 9. inner (exit)
	// 10. parse_inner
	// 11. (child)
    
	this.replace_element = function( element, data, records, in_record, is_record ) {
		
		// hasAttribute not supported on MSXML.DomDocument
		
		if ( element.getAttribute( this.templateAttribute ) == null ) {
			var childs = [] ;
			
			for ( var n = 0 ; n < element.childNodes.length ; n++ ) {
				if ( element.childNodes.item( n ).nodeType == XML_ELEMENT_NODE ) {
					childs.push( element.childNodes.item( n ) ) ;
				}
			}
			
			for ( var n = 0 ; n < childs.length ; n++ ) {
				this.replace_element( childs[ n ], data, records, in_record ) ;
			}
			
			return ;
		}
		
		var commands = this._get_template_commands( element ) ;
	    
		if ( ! is_record ) {
			
		    // fake
		    
			if ( typeof commands[ 'fake' ] != 'undefined' ) {
				this.replace_remove( element ) ;
				return ;
			}
			
		    // record
		    
			if ( typeof commands[ 'record' ] != 'undefined' ) {
				this.replace_command_record( element, data, commands[ 'record' ], records, in_record ) ;
				return ;
			}
			
		    // if/else
		    
			if ( typeof commands[ 'condition' ] != 'undefined' ) {
				for ( var n = 0 ; n < commands[ 'condition' ].length ; n++ ) {
					var condition = commands[ 'condition' ][ n ][ 'condition' ] ;
					var name = commands[ 'condition' ][ n ][ 'name' ] ;
					
					var check = false ;
					
					var local = this._get_template_value_local( data, name ) ;
					
					if ( typeof local.data[ 'condition' ] != 'undefined' ) {
						if ( typeof local.data[ 'condition' ][ local.name ] != 'undefined' ) {
							check = local.data[ 'condition' ][ local.name ] ;
						} else {
							if ( typeof local.data[ 'record' ][ local.name ] != 'undefined' ) {
								check = ( local.data[ 'record' ][ local.name ].length > 0 ) ;
							} else {
								if ( typeof local.data[ 'value' ][ local.name ] != 'undefined' ) {
									check = ( '' + local.data[ 'value' ][ local.name ] != '' ) ;
								}
							}
						}
					}
					
					if ( check != condition ) {
						this.replace_remove( element ) ;
						return ;
					}
				}
			}
			
		    // parse_outer
			
			if ( typeof commands[ 'parse_outer' ] != 'undefined' ) {
				this.replace_parse_outer( element, data, commands[ 'parse_outer' ], records, in_record ) ;
			    return ;
			}
			
		    // outer
		    
			if ( typeof commands[ 'outer' ] != 'undefined' ) {
			    if ( in_record ) {
					if ( typeof commands[ 'outer' ] != 'undefined' ) {
						this.replace_parse_outer( element, data, commands[ 'outer' ], records, in_record ) ;
					}
				} else {
					
					// pending outer
					
					var html = this._get_template_contents( data, commands[ 'outer' ] ) ;
					
					if ( typeof html != "undefined" ) {
						this.replace_pending.push( {
							'command'	: 'outer',
							'text'		: html,
							'element'	: element
						} ) ;
					}
			    }
			    
			    return ;
	    	}
		}
	    
	    // @ - attribute
	    
		if ( typeof commands[ '@' ] != 'undefined' ) {
			for ( var n = 0 ; n < commands[ '@' ].length ; n++ ) {
				var attribute = commands[ '@' ][ n ][ 'attribute' ] ;
				var name = commands[ '@' ][ n ][ 'name' ] ;
				
				var local = this._get_template_value_local( data, name ) ;
				
				if ( typeof local.data[ 'value' ] != 'undefined' ) {
					if ( typeof local.data[ 'value' ][ local.name ] != 'undefined' ) {
						if ( '' + local.data[ 'value' ][ local.name ] == '' ) {
							if ( typeof this.blankAttribute[ attribute ] != 'undefined' ) {
				            	element.removeAttribute( attribute ) ;
								continue ;
							}
						}
						
				        element.setAttribute( attribute, local.data[ 'value' ][ local.name ] ) ;
					}
				}
			}
		}
	    
		// other - function / extended method
		
		if ( typeof commands[ 'other' ] != 'undefined' ) {
			for ( var n = 0 ; n < commands[ 'other' ].length ; n++ ) {
				var command = commands[ 'other' ][ n ][ 'command' ] ;
				var name = commands[ 'other' ][ n ][ 'name' ] ;
				
				if ( command == 'function' ) {
					var local = this._get_template_value_local( data, name ) ;
					
					if ( typeof local.data[ 'function' ] != 'function' ) {
						if ( typeof local.data[ 'function' ][ local.name ] == 'function' ) {
							local.data[ 'function' ][ local.name ]( this, element, data, command, name ) ;
						}
					}
				} else {
					var method = 'command_' + command ;
					
					if ( typeof this[ method ] == "function" ) {
						this[ method ]( element, data, command, name ) ;
					}
				}
			}
		}
	    
	    // text
	    
		if ( typeof commands[ 'text' ] != 'undefined' ) {
			var name = commands[ 'text' ] ;
			var local = this._get_template_value_local( data, name ) ;
			
			if ( typeof local.data[ 'value' ] != 'undefined' ) {
				if ( typeof local.data[ 'value' ][ local.name ] != 'undefined' ) {
					var html = this.htmlspecialchars( local.data[ 'value' ][ local.name ] ).replace( /(\r?\n)/g, "<br" + this.tagEnd + ">$1" ) ;
					
					while ( element.childNodes.length > 0 ) {
						element.removeChild( element.firstChild ) ;
					}
					
					var dom = new DOMParser().parseFromString( '<dom>' + html + '</dom>', 'application/xhtml+xml' ) ;
	
					for ( var n = 0 ; n < dom.documentElement.childNodes.length ; n++ ) {
						element.appendChild( dom.documentElement.childNodes.item( n ).cloneNode( true ) ) ;
					}
	
					delete dom ;
				}
			}
			
			return ;
		}
	    
	    // textarea
	    
		if ( typeof commands[ 'textarea' ] != 'undefined' ) {
			var name = commands[ 'textarea' ] ;
			var local = this._get_template_value_local( data, name ) ;
			
			if ( typeof local.data[ 'value' ] != 'undefined' ) {
				if ( typeof local.data[ 'value' ][ local.name ] != 'undefined' ) {
					var html = this.htmlspecialchars( local.data[ 'value' ][ local.name ] ).replace( /(\r?\n)/g, "<br" + this.tagEnd + ">$1" ) ;
					
					while ( element.childNodes.length > 0 ) {
						element.removeChild( element.firstChild ) ;
					}
					
					element.appendChild( this.dom.createTextNode( html ) ) ;
				}
			}
			
			return ;
		}
    	
    	// inner
    	
		if ( typeof commands[ 'inner' ] != 'undefined' ) {
			if ( in_record ) {
				this.replace_parse_inner( data, commands[ 'parse_inner' ], element, records, in_record ) ;
			} else {
				
				// pending inner
				
				var html = this._get_template_contents( data, commands[ 'inner' ] ) ;
				
				if ( typeof html != "undefined" ) {
					this.replace_pending.push( {
						'command'	: 'inner',
						'text'		: html,
						'element'	: element
					} ) ;
				}
			    
			    return ;
	    	}
		}
    	
    	// parse_inner
    	
		if ( typeof commands[ 'parse_inner' ] != 'undefined' ) {
			this.replace_parse_inner( element, data, commands[ 'parse_inner' ], records, in_record ) ;
		}
		
		// childs
		
		var childs = [] ;
		
		for ( var n = 0 ; n < element.childNodes.length ; n++ ) {
			if ( element.childNodes.item( n ).nodeType == XML_ELEMENT_NODE ) {
				childs.push( element.childNodes.item( n ) ) ;
			}
		}
		
		for ( var n = 0 ; n < childs.length ; n++ ) {
			this.replace_element( childs[ n ], data, records, in_record ) ;
		}
	} ;
	
	
	// record: name
	
	this.replace_command_record = function( element, data, command, records, in_record ) {
		var name = command ;
		var local = this._get_template_value_local( data, name ) ;
		
		if ( typeof local.data[ 'record' ] == 'undefined' ) {
			this.replace_remove( element ) ;
			return ;
		}
		
		if ( typeof local.data[ 'record' ][ local.name ] == 'undefined' ) {
			this.replace_remove( element ) ;
			return ;
		}
		
		if ( local.data[ 'record' ][ local.name ].length == 0 ) {
			this.replace_remove( element ) ;
			return ;
		}
		
		if ( typeof records[ name ] == 'undefined' ) {
			records[ name ] = {
				'data'		: local.data[ 'record' ][ local.name ],
				'elements'	: []
			} ;
		}
		
		var n = records[ name ][ 'elements' ].length ;
		
		if ( n == records[ name ][ 'data' ].length ) {
			this.replace_remove( element ) ;
			return ;
		}
		
		records[ name ][ 'data' ][ n ][ 'root' ] = this.data ;
		records[ name ][ 'data' ][ n ][ 'parent' ] = data ;
		
		records[ name ][ 'elements' ].push( {
			'element'	: element,
			'records'	: {}
		} ) ;
		
		this.replace_element(
			records[ name ][ 'elements' ][ n ][ 'element' ],
			records[ name ][ 'data' ][ n ],
			records[ name ][ 'elements' ][ n ][ 'records' ],
			true,
			true
		) ;
		
		return ;
	} ;
	
	
	this.replace_record = function( record ) {
		
		// 不足分作成
		
		if ( record[ 'elements' ].length < record[ 'data' ].length ) {
			var parent = record[ 'data' ][ record[ 'elements' ].length - 1 ][ 'parent' ] ;
			var last = record[ 'elements' ][ record[ 'elements' ].length - 1 ][ 'element' ] ;
			
			// 追加位置
			
			var anchor = this.dom.createElement( last.tagName ) ;
			
			if ( last.nextSibling ) {
				last.parentNode.insertBefore( anchor, last.nextSibling ) ;
			} else {
				last.parentNode.appendChild( anchor ) ;
			}
			
			// 追加材料
			
			var source = [] ;
			
			if ( last.previousSibling ) {
				if ( last.previousSibling.nodeType == XML_TEXT_NODE ) {
					if ( last.previousSibling.nodeValue.match( /^\s*$/ ) ) {
						source.push( last.previousSibling.cloneNode( true ) ) ;
					}
				}
			}
			
			// 追加
			
			for ( var n = record[ 'elements' ].length ; n < record[ 'data' ].length ; n++ ) {
				for ( var s = 0 ; s < source.length ; s++ ) {
					last.parentNode.insertBefore( source[ s ].cloneNode( true ), anchor ) ;
				}
				
				var element = last.cloneNode( true ) ;
				last.parentNode.insertBefore( element, anchor ) ;
				
				record[ 'data' ][ n ][ 'root' ] = this.data ;
				record[ 'data' ][ n ][ 'parent' ] = parent ;
				
				record[ 'elements' ].push( {
					'element'	: element,
					'records'	: {}
				} ) ;
				
				this.replace_element(
					record[ 'elements' ][ n ][ 'element' ],
					record[ 'data' ][ n ],
					record[ 'elements' ][ n ][ 'records' ],
					true,
					true
				) ;
			}
			
			last.parentNode.removeChild( anchor ) ;
		}
		
		// 子レコード
		
		for ( var n = 0 ; n < record[ 'elements' ].length ; n++ ) {
			for ( var name in record[ 'elements' ][ n ][ 'records' ] ) {
				this.replace_record( record[ 'elements' ][ n ][ 'records' ][ name ] ) ;
			}
		}
	} ;
	
	
	this.replace_remove = function( element ) {
		if ( element.previousSibling ) {
			if ( element.previousSibling.nodeType == XML_TEXT_NODE ) {
				if ( element.previousSibling.nodeValue.match( /^\s*$/ ) ) {
					element.parentNode.removeChild( element.previousSibling ) ;
				}
			}
		}
		
		element.parentNode.removeChild( element ) ;
	}
	
	
	this.replace_parse_outer = function( element, data, name, records, in_record ) {
		var html = this._get_template_contents( data, name ) ;
		
		if ( typeof html == "undefined" ) {
			return ;
		}
		
		var childs = [] ;
		
		var dom = new DOMParser().parseFromString( '<dom>' + html + '</dom>', 'application/xhtml+xml' ) ;

		for ( var n = 0 ; n < dom.documentElement.childNodes.length ; n++ ) {
			var child = dom.documentElement.childNodes.item( n ).cloneNode( true ) ;
			
			element.parentNode.insertBefore( child, element ) ;
			
			if ( child.nodeType == XML_ELEMENT_NODE ) {
				childs.push( child ) ;
			}
		}

		delete dom ;
		
		element.parentNode.removeChild( element ) ;
		
		for ( var n = 0 ; n < childs.length ; n++ ) {
			this.replace_element( childs[ n ], data, records, in_record ) ;
		}
	} ;
	
	
	this.replace_parse_inner = function( element, data, name, records, in_record ) {
		var html = this._get_template_contents( data, name ) ;
		
		if ( typeof html == "undefined" ) {
			return ;
		}
		
		html = this._inner_keep_indent( element, html ) ;
		
		while ( element.childNodes.length > 0 ) {
			element.removeChild( element.firstChild ) ;
		}

		var dom = new DOMParser().parseFromString( '<dom>' + html + '</dom>', 'application/xhtml+xml' ) ;

		for ( var n = 0 ; n < dom.documentElement.childNodes.length ; n++ ) {
			element.appendChild( dom.documentElement.childNodes.item( n ).cloneNode( true ) ) ;
		}
		
		delete dom ;
	} ;
	
	
	//==================================================================
	// save
	
	this.save = function() {
		this.pending_script = [] ;
		
		var html = document.documentElement ;
		var doc = this.dom.documentElement ;
		
		// clear head, body
		
		var elements = {} ;
		
		for ( var n = 0 ; n < html.childNodes.length ; n++ ) {
			if ( html.childNodes.item( n ).nodeType != XML_ELEMENT_NODE ) {
				continue ;
			}
			
			var element = html.childNodes.item( n ) ;
			var tagName = element.tagName.toLowerCase() ;
			
			elements[ tagName ] = element ;
			
			while ( element.childNodes.length > 0 ) {
				element.removeChild( element.firstChild ) ;
			}
		}
		
		// head, body
		
		this.save_attributes( html, doc ) ;
		
		for ( var n = 0 ; n < doc.childNodes.length ; n++ ) {
			if ( doc.childNodes.item( n ).nodeType != XML_ELEMENT_NODE ) {
				continue ;
			}
			
			var doc_element = doc.childNodes.item( n ) ;
			var tagName = doc_element.tagName.toLowerCase() ;
			
			if ( ! elements[ tagName ] ) {
				continue ;
			}
			
			this.save_child( elements[ tagName ], doc_element ) ;
		}
		
		if ( this.isMSIE ) {
			for ( var n = 0 ; n < this.pending_script.length ; n++ ) {
				this.pending_script[ n ].element.text = this.pending_script[ n ].script ;
			}
		} else {
			var e = document.createEvent( "HTMLEvents" ) ;
			e.initEvent( "load" , true, true ) ;
			window.dispatchEvent( e ) ;
		}
	} ;
	
	this.save_child = function( html, doc ) {
		
		// attributes
		
		this.save_attributes( html, doc ) ;
		
		// childNodes
		
		for ( var c = 0 ; c < doc.childNodes.length ; c++ ) {
			var doc_child = doc.childNodes.item( c ) ;
			
			switch ( doc_child.nodeType ) {
			case XML_ELEMENT_NODE :
				var tagName = doc_child.tagName.toLowerCase() ;
				
				if ( this.isMSIE ) {
					if ( tagName == 'title' ) {
						if ( doc_child.childNodes.length > 0 ) {
							if ( doc_child.firstChild.nodeType == XML_TEXT_NODE ) {
								document.title = doc_child.firstChild.nodeValue ;
							}
						}
						
						break ;
					}
				}
				
				var child = document.createElement( tagName ) ;
				html.appendChild( child ) ;
				this.save_child( child, doc_child ) ;
				
				break ;
			
			case XML_TEXT_NODE :
				if ( this.isMSIE ) {
					
					// TODO: title not reflected
					
					switch ( html.tagName.toLowerCase() ) {
					case 'style' :
						html.styleSheet.cssText = doc_child.nodeValue ;
						break ;
					case 'script' :
						this.pending_script.push( { 'element' : html, 'script' : doc_child.nodeValue } ) ;
						break ;
					default :
						html.appendChild( document.createTextNode( doc_child.nodeValue ) ) ;
					}
				} else {
					html.appendChild( document.createTextNode( doc_child.nodeValue ) ) ;
				}
				
				break ;
			
			case XML_CDATA_SECTION_NODE :
				html.appendChild( document.createCDATASection( doc_child.nodeValue ) ) ;
				break ;
			
			case XML_COMMENT_NODE :
				html.appendChild( document.createComment( doc_child.nodeValue ) ) ;
				break ;
			}
		}
	} ;
	
	this.save_attributes = function( html, doc ) {
		for ( var a = 0 ; a < doc.attributes.length ; a++ ) {
			if ( doc.attributes.item( a ).name == jte.templateAttribute ) {
				continue ;
			}
			
			if ( this.isMSIE ) {
				if ( doc.attributes.item( a ).name == 'class' ) {
					html.className = doc.attributes.item( a ).value ;
					continue ;
				}
				
				if ( doc.attributes.item( a ).name == 'style' ) {
					html.style.cssText = doc.attributes.item( a ).value ;
					continue ;
				}
			}
			
			html.setAttribute( doc.attributes.item( a ).name, doc.attributes.item( a ).value ) ;
		}
	}
	
	
	//==================================================================
	// execute
	
	this.execute = function( path, data ) {
		this.set( data ) ;
		this.load( path ) ;
		this.replace() ;
		this.save() ;
	} ;
	
	
	//==================================================================
	// part
	
	this.part_load = function( html ) {
		html = this.delete_bom( html ) ;
		html = html.replace( /(^\s+|\s+$)/g, '' ) ;
		
		html = "<part>" + html + "</part>" ;
		
		this.dom = new DOMParser().parseFromString( html, 'application/xhtml+xml' ) ;
	} ;
	
	
	this.part_replace = function( data ) {
		records = {} ;
		
		this.replace_childs( this.dom, data, records ) ;
		
		for ( var name in records ) {
			this.replace_record( records[ name ] ) ;
		}
	} ;
	
	
	this.part_save = function( data ) {
		var html = "" ;
		
		for ( var n = 0 ; n < this.dom.documentElement.childNodes.length ; n++ ) {
			this._tree( html, this.dom.documentElement.childNodes.item( $n ), data ) ;
		}
		
		return html ;
	} ;
	
	
	this.part_execute = function( html, data ) {
		this.part_load( html ) ;
		this.part_replace( data ) ;
		return this.part_save( data ) ;
	} ;
	
	
	//==================================================================
	// _get_template_commands
	  
	this._get_template_commands = function( element ) {
		var attributes = element.getAttribute( this.templateAttribute ).replace( /(^\s+|\s+$)/g, "" ).split( /\s*;\s*/ ) ;
		
		var commands = {} ;
		
		for ( var a = 0 ; a < attributes.length ; a++ ) {
			var command_name = attributes[ a ].replace( /(^\s+|\s+$)/g, "" ) ;
			
			if ( command_name == '' ) {
				continue ;
			}
			
			if ( command_name.match( /^([^:]*)\s*:\s*([\s\S]*)$/ ) ) {
				var command = RegExp.$1 ;
				var name = RegExp.$2 ;
			} else {
				var command = command_name ;
				var name = '' ;
			}
			
			if ( command.match( /^@([\s\S]+)$/ ) ) {
				var attribute = RegExp.$1 ;
				
				if ( typeof commands[ '@' ] == "undefined" ) {
					commands[ '@' ] = [] ;
				}
				
		        commands[ '@' ].push( { 'attribute' : attribute, 'name' : name } ) ;
		        
		        continue ;
			}
			
			switch ( command ) {
				case 'fake' :
				case 'remove' :
				case 'dummy' :
					commands[ 'fake' ] = true ;
					break ;
				
				case 'record' :
				case 'parse_outer' :
				case 'parse_inner' :
				case 'outer' :
				case 'inner' :
				case 'text' :
				case 'textarea' :
					commands[ command ] = name ;
					break ;
					
				case 'pre' :
					commands[ 'textarea' ] = name ;
					break ;
					
				case 'if' :
				case 'else' :
				case 'condition' :
				case 'condition_not' :
					var condition = ( ( command == 'if' ) || ( command == 'condition' ) ) ;
					
					if ( typeof commands[ 'condition' ] == "undefined" ) {
						commands[ 'condition' ] = [] ;
					}
					
			        commands[ 'condition' ].push( { 'condition' : condition, 'name' : name } ) ;
			        
					break ;
				
				default :
					if ( typeof commands[ 'other' ] == "undefined" ) {
						commands[ 'other' ] = [] ;
					}
					
					commands[ 'other' ].push( { 'command' : command, 'name' : name } ) ;
			}
		}
		
	    return commands ;
	} ;
	
	
	//==================================================================
	// _get_template_contents
	
	this._get_template_contents = function( data, name ) {
		if ( name.match( /^url\(([^)]*)\)$/ ) ) {
			var urls = RegExp.$1.split( /(\s+|\s*,\s*)/ ) ;
			
			var parts = [] ;
			
			for ( var n = 0 ; n < urls.length ; n++ ) {
				var url = urls[ n ].replace( /(^\s+|\s+$)/g, '' ) ;
				
				if ( url == '' ) {
					continue ;
				}
				
				parts.push( this.get_contents( url ) ) ;
			}
			
			return parts.join( "\n" ) ;
		}
		
	    return this._get_template_value( data, name ) ;
	} ;
	
	
	//==================================================================
	// _get_template_value
	
	this._get_template_value = function( data, name ) {
		var local = this._get_template_value_local( data, name ) ;
		
		if ( typeof local.data[ 'value' ][ local.name ] == "undefined" ) {
			return ;
		}
		
		return  local.data[ 'value' ][ local.name ] ;
	} ;
	
	
	//==================================================================
	// _get_template_value_local
	
	this._get_template_value_local = function( data, name ) {
		var localData = data ;
		var localName = name ;
		
		if ( name.match( /^(\S+?)\.(.+)$/ ) ) {
			var workData = RegExp.$1.toLowerCase() ;
			var workName = RegExp.$2.replace( /(^\s+|\s+$)/g, '' ) ;
			
			switch( workData ) {
				case 'root' :
				case 'parent' :
					localData = data[ workData ] ;
					localName = workName ;
					break ;
			}
		}
		
		return { data : localData, name : localName } ;
	} ;
	
	
	//==================================================================
	// _inner_keep_indent
	
	this._inner_keep_indent = function( element, html ) {
		if ( element.childNodes.length == 0 ) {
			return html ;
		}
		
		var first = '' ;
		var last = '' ;
	    
		// 開始タグの後の改行までの空白・コメントを保持
		
		while ( element.childNodes.length > 0 ) {
			if ( element.firstChild.nodeType == XML_TEXT_NODE ) {
				var text = element.firstChild.nodeValue ;
				
		        // 改行がある場合(終了)
		        
		        if ( text.match( /^([\s\S]*?)(\r?\n)([\s\S]*)$/ ) ) {
		        	var space = RegExp.$1 ;
		        	var lf = RegExp.$2 ;
		        	var other = RegExp.$3 ;
		        	
		        	if ( space.match( /^\s*$/ ) ) {
		        		first = first + space + lf ;
		        		element.firstChild.nodeValue = lf + other ;
		        	} else {
			            first = first + lf ;
		        	}
		        	
		        	break ;
		        }
				
		        // 空白でない場合(終了)
		        
	        	if ( ! text.match( /^\s*$/ ) ) {
		        	break ;
		        }
		        
		        // 空白を保持
		        
		        first = first + text ;
		        element.removeChild( element.firstChild ) ;
		        
		        continue ;
			}
			
			// コメントを保持
			
			if ( element.firstChild.nodeType == XML_COMMENT_NODE ) {
				first = first + "<!--" + element.firstChild.nodeValue + "-->" ;
				element.removeChild( element.firstChild ) ;
				
				continue ;
			}
			
			break ;
		}
		
	    // 閉じタグのインデントを保持
	    
		while ( element.childNodes.length > 0 ) {
			if ( element.lastChild.nodeType == XML_TEXT_NODE ) {
				var text = element.lastChild.nodeValue ;
				
		        // 改行がある場合(終了)
		        
		        if ( text.match( /^([\s\S]*)(\r?\n)([\s\S]*?)$/ ) ) {
		        	var other = RegExp.$1 ;
		        	var space = RegExp.$3 ;
		        	var lf = RegExp.$2 ;
		        	
		        	if ( space.match( /^\s*$/ ) ) {
		        		last = lf + space + last ;
		        		element.lastChild.nodeValue = other + lf ;
		        	} else {
		        		last = lf + last ;
		        	}
		        	
		        	break ;
		        }
				
		        // 空白でない場合(終了)
		        
	        	if ( ! text.match( /^\s*$/ ) ) {
		        	break ;
		        }
		        
		        // 空白を保持
		        
		        last = last + text ;
		        element.removeChild( element.lastChild ) ;
		        
		        continue ;
			}
			
			// コメントを保持
			
			if ( element.lastChild.nodeType == XML_COMMENT_NODE ) {
				last = "<!--" + element.lastChild.nodeValue + "-->" + last ;
				element.removeChild( element.lastChild ) ;
				
				continue ;
			}
			
			break ;
		}
		
	    return first + html + last ;
	} ;
	
	
	//==================================================================
	// get_contents
	
	this.get_contents = function( path, callback ) {
		var jte = this ;
		
		if ( typeof XMLHttpRequest != "undefined" ) {
			var req = new XMLHttpRequest ;
		} else {
			if ( typeof ActiveXObject == "function" ) {
		        var req = new ActiveXObject( "Microsoft.XMLHTTP" ) ;
		    } else {
				callback.apply( jte, [ '' ] ) ;
				return ;
		    }
		}
		
		if ( callback ) {
			req.open( "GET", path, true ) ;
			
			req.onreadystatechange = function() {
				if ( req.readyState == 4 ) {
					callback.apply( jte, [ req.responseText ] ) ;
				}
			} ;
		} else {
			req.open( "GET", path, false ) ;
		}
		
		req.setRequestHeader( "If-Modified-Since", "Thu, 01 Jun 1970 00:00:00 GMT" ) ;

		req.send( null ) ;
		
		if ( callback ) return ;
		
		return req.responseText ;
	} ;
	
	
	//==================================================================
	// htmlspecialchars
	
	this.htmlspecialchars = function( text ) {
		text = text.replace( /&/g, '&amp;' ) ;
		text = text.replace( /</g, '&lt;' ) ;
		text = text.replace( />/g, '&gt;' ) ;
		text = text.replace( /"/g, '&quot;' ) ;
		
		return text ;
	} ;
	
	
	//==================================================================
	// delete_bom
	
	this.delete_bom = function( text ) {
	    return text.replace( /^\xef\xbb\xbf/, '' ) ;
	} ;
} ;
